- [API Reference - `log`](#api-reference---log)
  - [Logging functions](#logging-functions)
    - [`log.trace(message)`](#logtracemessage)
    - [`log.debug(message)`](#logdebugmessage)
    - [`log.info(message)`](#loginfomessage)
    - [`log.warn(message)`](#logwarnmessage)
    - [`log.error(message)`](#logerrormessage)
    - [`log.trace_once(message)`](#logtrace_oncemessage)
    - [`log.debug_once(message)`](#logdebug_oncemessage)
    - [`log.info_once(message)`](#loginfo_oncemessage)
    - [`log.warn_once(message)`](#logwarn_oncemessage)
    - [`log.error_once(message)`](#logerror_oncemessage)

## API Reference - `log`

### Logging functions

This module allows you to log messages to the simulator console, used mostly for debugging purposes.

There are 5 functions (one for each log level) that print input string, and their "once" counterparts that only log the message once.

```lua
log.trace("message")
log.debug("message")
log.info("message")
log.warn("message")
log.error("message")

log.trace_once("message")
log.debug_once("message")
log.info_once("message")
log.warn_once("message")
log.error_once("message")
```

Use `client.rpc('log.trace', 'message')` to call these functions via Network API. Only argument is "message", which is always a string for RPC but can be any object if called from Lua.

```js
await client.rpc('log.trace', 'message')
await client.rpc('log.debug', 'message')
await client.rpc('log.info', 'message')
await client.rpc('log.warn', 'message')
await client.rpc('log.error', 'message')

await client.rpc('log.trace_once', 'message')
await client.rpc('log.debug_once', 'message')
await client.rpc('log.info_once', 'message')
await client.rpc('log.warn_once', 'message')
await client.rpc('log.error_once', 'message')
```

#### `log.trace(message)`
#### `log.debug(message)`
#### `log.info(message)`
#### `log.warn(message)`
#### `log.error(message)`
#### `log.trace_once(message)`
#### `log.debug_once(message)`
#### `log.info_once(message)`
#### `log.warn_once(message)`
#### `log.error_once(message)`

See above.
