import asyncio
from centrifuge import Client

async def main():
    client = Client('ws://localhost:9120/connection/websocket')
    await client.connect()

    await client.rpc('session.restart', None)
    await client.rpc('session.pause', None)

    await client.rpc('log.warn', 'Hello, world!')
    await client.rpc('map.spawn', {
        'mesh': 'trees/tree_a.glb',
        'position': { 'x': 1.5, 'y': 0 },
    })

    await client.disconnect()

asyncio.run(main())
