local MODEL_PATH = "spy-drone/spy-drone.glb"

local DRONE_HALF_HEIGHT = (0.075 - 0.01) / 2
local DRONE_HALF_WIDTH = 0.0928
local DRONE_HALF_LENGTH = 0.088
local DRONE_CENTER_HEIGHT = 0.0375
local DRONE_MASS = 0.8

local WHEEL_HEIGHT = 0.029
local WHEEL_SUSPENSION = WHEEL_HEIGHT * 1.1
local WHEEL_FWD_OFFSET = 0.046
local WHEEL_SIDE_OFFSET = 0.082

local WHEEL_MESHES = {
    { "wheel-FL", 1, 1 },   -- front left
    { "wheel-FR", 1, -1 },  -- front right
    { "wheel-RL", -1, 1 },  -- rear left
    { "wheel-RR", -1, -1 }, -- rear right
}

local function on_load(vehicle, meshes)
    -- log.info("UGV model loaded")

    vehicle:add_collider {
        shape = {
            type = "cuboid",
            hx = DRONE_HALF_LENGTH,
            hy = DRONE_HALF_WIDTH,
            hz = DRONE_HALF_HEIGHT,
        },
        position = { x = 0, y = 0, z = DRONE_CENTER_HEIGHT },
        friction = 0.9,
        mass = DRONE_MASS,
    }

    for _x, mesh_desc in ipairs(WHEEL_MESHES) do
        local name = mesh_desc[1]
        local dx = mesh_desc[2]
        local dy = mesh_desc[3]

        if meshes[name] == nil then
            sim.log.error("wheel mesh not found: " .. name)
            continue
        end

        vehicle:add_wheel(meshes[name], {
            chassis_connection_cs = {
                x = dx * WHEEL_FWD_OFFSET,
                y = dy * WHEEL_SIDE_OFFSET,
                z = WHEEL_HEIGHT,
            },
            direction_cs = { z = -1 },
            axle_cs = { y = -1 },
            suspension_rest_length = WHEEL_SUSPENSION,
            radius = WHEEL_HEIGHT,
            -- optional
            suspension_stiffness = 100.0,
            suspension_compression = 0.83,
            suspension_damping = 10.0,
            max_suspension_travel = 0.2,
            side_friction_stiffness = 1.0,
            friction_slip = 10.5,
            max_suspension_force = 600.0,
        })
    end
end

return {
    model = MODEL_PATH,
    on_load = on_load,
    limits = {
        max_force = 15,
        max_linvel = 50,
        max_angvel = 40,
    },
}
