- [API Reference - `session`](#api-reference---session)
    - [`session.run([speed])`](#sessionrunspeed)
    - [`session.pause()`](#sessionpause)
    - [`session.step()`](#sessionstep)
    - [`session.restart()`](#sessionrestart)
    - [`session.exit([code])`](#sessionexitcode)
    - [`session.state()`](#sessionstate)

## API Reference - `session`

This module allows you to get the state and interact with the simulation.

#### `session.run([speed])`

Starts or resumes simulation with a given speed. If no speed is provided, simulation will run with speed=1. You can use large number (f32::MAX or Infinity) to run with unlimited speed.

```lua
session.run()
session.run(4.0)
```

```js
await client.rpc('session.run')
await client.rpc('session.run', { speed: 4.0 })
```

#### `session.pause()`

Pauses simulation.

```lua
session.pause()
```

```js
await client.rpc('session.pause')
```

#### `session.step()`

Runs one step, then pauses simulation.

```lua
session.step()
```

```js
await client.rpc('session.step')
```

#### `session.restart()`

Restarts simulation from the beginning. Map will also be reset, so you need to spawn objects again if needed.

```lua
session.restart()
```

```js
await client.rpc('session.restart')
```

#### `session.exit([code])`

Exits simulator with a given code (in [0-255] range, 0 by default).

```lua
session.exit()
session.exit(1)
```

```js
await client.rpc('session.exit')
await client.rpc('session.exit', { code: 1 })
```

#### `session.state()`

Returns current simulation state (time elapsed, current sim-to-real speed).

```lua
local state = session.state()
```

```js
let state = await client.rpc('session.state')
// or subscribe
let sub = client.newSubscription('session.state')
```

Return value is a table with two fields:
 - `time_us` (u64) - time elapsed since start of simulation in microseconds
 - `speed` (f32) - current sim-to-real speed
