- [API Reference - `script`](#api-reference---script)
    - [`script.eval(params)`](#scriptevalparams)

## API Reference - `script`

#### `script.eval(params)`

Evaluate a Lua script. This is used to batch multiple RPC calls into one, or to implement a custom logic (e.g. abstract sensors).

Parameters is a table with the following fields:
 - `code` (string) - Lua code to execute.
 - `args` (any, optional) - value of the ARGS global variable, used to pass in parameters to the script.

```js
let result = await client.rpc("script.eval", {
    code: "{ time = sim.session.state().time_us }",
})
console.log(result.data) // { time: 123456789 }
```

You can pass parameters to the script using the `args` field. Example:

```js
let result = await client.rpc("script.eval", {
    code: "ARGS.a + ARGS.b * ARGS.c",
    args: { a: 11, b: 22, c: 33 },
})
console.log(result.data) // 737
```
