import { Centrifuge } from 'npm:centrifuge'

async function main() {
    let client = new Centrifuge('ws://localhost:9120/connection/websocket')
    await client.connect()

    await client.rpc('session.restart')
    await client.rpc('session.pause')

    await client.rpc('log.warn', 'Hello, world!')
    await client.rpc('map.spawn', {
        mesh: 'trees/tree_a.glb',
        position: { x: 1.5, y: 0 },
    })

    await client.disconnect()
}

await main()
