#import bevy_pbr::forward_io::{Vertex, VertexOutput, FragmentOutput};
#import bevy_pbr::pbr_fragment::pbr_input_from_standard_material;
#import bevy_pbr::pbr_functions::{alpha_discard, apply_pbr_lighting, main_pass_post_lighting_processing};
#import bevy_pbr::mesh_functions::{get_world_from_local, mesh_position_local_to_clip}

@group(2) @binding(100) var marking_color_texture: texture_2d<f32>;
@group(2) @binding(101) var marking_color_sampler: sampler;

@fragment fn fragment(
    in: VertexOutput,
    @builtin(front_facing) is_front: bool,
) -> FragmentOutput {
    // generate a PbrInput struct from the StandardMaterial bindings
    var pbr_input = pbr_input_from_standard_material(in, is_front);

    // alpha discard
    pbr_input.material.base_color = alpha_discard(pbr_input.material, pbr_input.material.base_color);

    var out: FragmentOutput;

    // apply lighting
    out.color = apply_pbr_lighting(pbr_input);

    // apply in-shader post processing (fog, alpha-premultiply, and also tonemapping, debanding if the camera is non-hdr)
    // note this does not include fullscreen postprocessing effects like bloom.
    out.color = main_pass_post_lighting_processing(pbr_input, out.color);

    // darken the color a bit (should be done in material properties)
    out.color = out.color * 0.5;

    // use uv_b channel to store position along road (uv is used by standard material as global coords)
    var uv = in.uv_b;

    // move the uv to the center of the road
    uv.y += 0.5;

    let t = textureSample(marking_color_texture, marking_color_sampler, uv);

    // blend asphalt texture with road marking texture
    out.color = out.color + vec4<f32>(out.color.xyz * 5 * t.xyz * t.a, 0);

    return out;
}
